using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace ModbusTest
{
    public partial class Form1 : Form
    {
        
        //½tcpӾÿ½ӶһµĶ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_TCPConnectMDBServer([MarshalAs(UnmanagedType.LPStr)] string szip,
            int port,
            int nConnTimeout);
        

        //½ĴӾÿ½ӶһµĶ 
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_SerConnectMDBServer(   int		iRtuAscii,
											            [MarshalAs(UnmanagedType.LPStr)] string szcom,
  			   								            int		iBautRate,
											            int		iByteSize,
											            int		iParity, 
											            int		iStopBits, 
											            int		iDtrCtl, 
											            int		iRtsCtl, 
											            int		iCtsCtl, 
											            int		iDsrCtl,
                                                        int		iResponse);

        //Ͽ
        [DllImport("ZModbusSdk.dll")]
        static extern void ZMB_DisConnectMDBServer(  UInt32 hand);

        //Ȧ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_ReadCoil(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            int nCount,
                                            ref byte bRet/*arr of coils*/,
                                            int TranID);
        //ɢ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_ReadInput(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            int nCount,
                                            ref byte bRet/*arr of coils*/,
                                            int TranID);
        //ּĴ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_ReadHoldReg(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            int nCount,
                                            ref short bRet/*arr of coils*/,
                                            int TranID);
        //Ĵ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_ReadInputReg(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            int nCount,
                                            ref short bRet/*arr of coils*/,
                                            int TranID);

        //дȦ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_WriteCoilSingle(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            short wData,
                                            int TranID);
        //дȦ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_WriteCoilMulitiple(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            int nCount,
                                            ref byte bRet/*arr of coils*/,
                                            int TranID);
        //дĴ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_WriteRegSingle(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            short wData,
                                            int TranID);


        //дĴ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_WriteRegMulitiple(UInt32 hand,
                                            byte serID,
                                            int nStart,
                                            int nCount,
                                            ref short writeDataArr,
                                            int TranID);
        //д
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_WriteCmdBuf(UInt32 hand,
                                            ref byte writeDataArr,
                                            int buflen,
                                            int TranID);
        //ȡӦ
        [DllImport("ZModbusSdk.dll")]
        static extern UInt32 ZMB_ReadRecBuf(UInt32 hand,
                                            ref byte Readbuf,
                                            int nBufLen,
                                            ref int pReadLen,
                                            int TranID);





        
    
        public Form1()
        {
            InitializeComponent();
        }

        private void ETH_CONNECT_Click(object sender, EventArgs e)
        {
            iIDEth = Byte.Parse(ETH_ID.Text);

            hHandleEth =  ZMB_TCPConnectMDBServer(ETH_IP.Text, Int32.Parse(ETH_PORT.Text), Int32.Parse(ETH_TIMEOUT.Text));
            if (hHandleEth == 0)
            {
                MessageBox.Show("ʧ");
            }
            else
            {
                MessageBox.Show("ӳɹ");
            }
        }

        private void SER_CONNECT_Click(object sender, EventArgs e)
        {

            int iWorkType = 0;

            iIDSer = Byte.Parse(SER_ID.Text);

            if (radioRTU.Checked == true)
                iWorkType = 0;
            else
                iWorkType = 1;

            hHandleSer = ZMB_SerConnectMDBServer(iWorkType, comboBox_com.Text, Int32.Parse(comboBox_baud.Text), Int32.Parse(SER_DB.Text),
                Int32.Parse(SER_CB.Text), Int32.Parse(SER_SB.Text), 0, 0, 0, 0, Int32.Parse(SER_TIMEOUT.Text));

            if (hHandleSer == 0)
            {
                MessageBox.Show("ʧ");
            }
            else
            {
                MessageBox.Show("ӳɹ");
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            iAddr = Int32.Parse(COIL_S_ADDR.Text);
            Byte[] bCoil = new Byte[20];

            if (hHandleEth != 0)
            {
                iret = ZMB_ReadCoil(hHandleEth, iIDEth, iAddr, 1, ref bCoil[0], 0);

                COIL_S_DATA.Text = System.Convert.ToString(bCoil[0]);
            }

            if (hHandleSer != 0)
            {
                iret = ZMB_ReadCoil(hHandleSer, iIDEth, iAddr, 1, ref bCoil[0], 0);

                COIL_S_DATA.Text = System.Convert.ToString(bCoil[0]);
            }
            

        }

        private void button4_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            iAddr = Int32.Parse(COIL_S_ADDR.Text);

            short wData = 0;
            wData = Int16.Parse(COIL_S_DATA.Text);

            if (hHandleEth != 0)
            {
                iret = ZMB_WriteCoilSingle(hHandleEth, iIDEth, iAddr, wData, 0);

                //COIL_S_DATA.Text = System.Convert.ToString(bCoil[0]);
            }

            if (hHandleSer != 0)
            {
                iret = ZMB_WriteCoilSingle(hHandleSer, iIDEth, iAddr, wData, 0);

                //COIL_S_DATA.Text = System.Convert.ToString(bCoil[0]);
            }

        }

        private void ReadMCoil_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            int iCount = 0;
            iAddr = Int32.Parse(COIL_M_ADDR.Text);
            iCount = Int32.Parse(COIL_M_COUNT.Text);

            Byte[] bCoil = new Byte[20];

            if (hHandleEth != 0)
            {
                iret = ZMB_ReadCoil(hHandleEth, iIDEth, iAddr, iCount, ref bCoil[0], 0);

                COIL_DATA_M_1.Text = System.Convert.ToString(bCoil[0]);
                COIL_DATA_M_2.Text = System.Convert.ToString(bCoil[1]);
            }

            if (hHandleSer != 0)
            {
                iret = ZMB_ReadCoil(hHandleSer, iIDEth, iAddr, iCount, ref bCoil[0], 0);

                COIL_DATA_M_1.Text = System.Convert.ToString(bCoil[0]);
                COIL_DATA_M_2.Text = System.Convert.ToString(bCoil[1]);
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            int iCount = 0;
            iAddr = Int32.Parse(COIL_M_ADDR.Text);
            iCount = Int32.Parse(COIL_M_COUNT.Text);

            Byte[] bCoil = new Byte[20];
            bCoil[0] = Byte.Parse(COIL_DATA_M_1.Text);
            bCoil[1] = Byte.Parse(COIL_DATA_M_2.Text);

            if (hHandleEth != 0)
            {
                iret = ZMB_WriteCoilMulitiple(hHandleEth, iIDEth, iAddr, iCount, ref bCoil[0], 0);

            }

            if (hHandleSer != 0)
            {
                iret = ZMB_WriteCoilMulitiple(hHandleSer, iIDEth, iAddr, iCount, ref bCoil[0], 0);

            }
        }

        private void ReadSReg_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            iAddr = Int32.Parse(REG_S_ADDR.Text);
            Int16[] iReg = new Int16[20];

            if (hHandleEth != 0)
            {
                iret = ZMB_ReadHoldReg(hHandleEth, iIDEth, iAddr, 1, ref iReg[0], 0);

                REG_S_DATA.Text = System.Convert.ToString(iReg[0]);
            }

            if (hHandleSer != 0)
            {
                iret = ZMB_ReadHoldReg(hHandleSer, iIDEth, iAddr, 1, ref iReg[0], 0);

                REG_S_DATA.Text = System.Convert.ToString(iReg[0]);
            }

        }

        private void WriteSReg_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            iAddr = Int32.Parse(REG_S_ADDR.Text);

            short wData = 0;
            wData = Int16.Parse(REG_S_DATA.Text);

            if (hHandleEth != 0)
            {
                iret = ZMB_WriteRegSingle(hHandleEth, iIDEth, iAddr, wData, 0);

                //COIL_S_DATA.Text = System.Convert.ToString(bCoil[0]);
            }

            if (hHandleSer != 0)
            {
                iret = ZMB_WriteRegSingle(hHandleSer, iIDEth, iAddr, wData, 0);

                //COIL_S_DATA.Text = System.Convert.ToString(bCoil[0]);
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            int iCount = 0;
            iAddr = Int32.Parse(REG_M_ADDR.Text);
            iCount = Int32.Parse(REG_M_COUNT.Text);

            Int16[] wReg = new Int16[20];

            if (hHandleEth != 0)
            {
                iret = ZMB_ReadHoldReg(hHandleEth, iIDEth, iAddr, iCount, ref wReg[0], 0);

                REG_M_DATA_1.Text = System.Convert.ToString(wReg[0]);
                REG_M_DATA_2.Text = System.Convert.ToString(wReg[1]);
            }

            if (hHandleSer != 0)
            {
                iret = ZMB_ReadHoldReg(hHandleSer, iIDEth, iAddr, iCount, ref wReg[0], 0);

                REG_M_DATA_1.Text = System.Convert.ToString(wReg[0]);
                REG_M_DATA_2.Text = System.Convert.ToString(wReg[1]);
            }

        }

        private void button9_Click(object sender, EventArgs e)
        {
            int iAddr = 0;
            uint iret = 0;
            int iCount = 0;
            iAddr = Int32.Parse(REG_M_ADDR.Text);
            iCount = Int32.Parse(REG_M_COUNT.Text);

            Int16[] wReg = new Int16[20];
            wReg[0] = Int16.Parse(REG_M_DATA_1.Text);
            wReg[1] = Int16.Parse(REG_M_DATA_2.Text);

            if (hHandleEth != 0)
            {
                iret = ZMB_WriteRegMulitiple(hHandleEth, iIDEth, iAddr, iCount, ref wReg[0], 0);

            }

            if (hHandleSer != 0)
            {
                iret = ZMB_WriteRegMulitiple(hHandleSer, iIDEth, iAddr, iCount, ref wReg[0], 0);

            }
        }

        private void DisConEth_Click(object sender, EventArgs e)
        {
            if (hHandleEth != 0)
            {
                ZMB_DisConnectMDBServer(hHandleEth);
                hHandleEth = 0;
            }
        }

        private void DisConnSer_Click(object sender, EventArgs e)
        {

            if (hHandleSer != 0)
            {
                ZMB_DisConnectMDBServer(hHandleSer);
                hHandleSer = 0;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Byte[] bData = new byte[100];
            bData[0] = 0;
            bData[1] = 1;
            bData[2] = 2;
            bData[3] = 3;
            bData[4] = 4;
            bData[5] = 5;
            bData[6] = 6;

            if (hHandleEth != 0)
            {
                ZMB_WriteCmdBuf(hHandleEth, ref bData[0], 10,  0);

            }

            if (hHandleSer != 0)
            {
                ZMB_WriteCmdBuf(hHandleSer, ref bData[0], 10, 0);

            }

            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Byte[] bData = new byte[100];
            Int32 iLen = 0;

            if (hHandleEth != 0)
            {
                ZMB_ReadRecBuf(hHandleEth, ref bData[0], 100, ref iLen, 0);

            }

            if (hHandleSer != 0)
            {
                ZMB_ReadRecBuf(hHandleSer, ref bData[0], 100, ref iLen, 0);

            }

        }


    }
}