unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ZModbusSDK;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BtnConnectEth: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    BtnConnectSer: TButton;
    EditIDEth: TEdit;
    EditIPEth: TEdit;
    EditPortEth: TEdit;
    EditTimeoutEth: TEdit;
    RadioButtonRTU: TRadioButton;
    RadioButton2: TRadioButton;
    EditDBSer: TEdit;
    EditCBSer: TEdit;
    EditSBSer: TEdit;
    EditTimeoutSer: TEdit;
    EditIDSer: TEdit;
    ComboBoxCom: TComboBox;
    ComboBoxBaud: TComboBox;
    GroupBox7: TGroupBox;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    GroupBox6: TGroupBox;
    Label21: TLabel;
    Label23: TLabel;
    BtnCoilSRead: TButton;
    BtnCoilSWrite: TButton;
    CoilSAddr: TEdit;
    CoilSData: TEdit;
    GroupBox8: TGroupBox;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    BtnCoilMRead: TButton;
    BtnCoilMWrite: TButton;
    CoilMAddr: TEdit;
    CoilMCount: TEdit;
    CoilMData1: TEdit;
    Label22: TLabel;
    CoilMData2: TEdit;
    GroupBox9: TGroupBox;
    Label24: TLabel;
    Label28: TLabel;
    BtnRegSRead: TButton;
    BtnRegSWrite: TButton;
    RegSAddr: TEdit;
    RegSData: TEdit;
    GroupBox10: TGroupBox;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    BtnRegMRead: TButton;
    BtnRegMWrite: TButton;
    RegMAddr: TEdit;
    RegMCount: TEdit;
    RegMData1: TEdit;
    RegMData2: TEdit;
    Button1: TButton;
    procedure BtnConnectEthClick(Sender: TObject);
    procedure BtnCoilSReadClick(Sender: TObject);
    procedure BtnConnectSerClick(Sender: TObject);
    procedure BtnCoilSWriteClick(Sender: TObject);
    procedure BtnCoilMReadClick(Sender: TObject);
    procedure BtnCoilMWriteClick(Sender: TObject);
    procedure BtnRegSReadClick(Sender: TObject);
    procedure BtnRegSWriteClick(Sender: TObject);
    procedure BtnRegMReadClick(Sender: TObject);
    procedure BtnRegMWriteClick(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }

    m_hHandleEth : THandle;
    m_hHandleSer : THandle;
    m_iIDEth: integer;
    m_iIDSer: integer;

  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.BtnConnectEthClick(Sender: TObject);
var
port: integer;
iTimeout : integer;

begin

  port := StrToInt(EditPortEth.Text) ;
  m_iIDEth := StrToInt(EditIDEth.Text);
  iTimeout := StrToInt(EditTimeoutEth.Text);

  m_hHandleEth :=   ZMB_TCPConnectMDBServer (PCHAR(EditIPEth.Text), port, iTimeout);
    If (m_hHandleEth <> 0) Then
        ShowMessage ('ӵɹ')
    Else
        ShowMessage ('ӵʧ');
  


end;

procedure TForm1.BtnCoilSReadClick(Sender: TObject);
var
bArr: array[0..100] of Byte;
iRet: Integer;
iAddr: integer;
begin
  iAddr := StrToInt(CoilSAddr.Text);

  if (m_hHandleEth <> 0) Then
  begin
    ZMB_ReadCoil(m_hHandleEth, m_iIDEth, iAddr, 1, @bArr[0], 0);
    CoilSData.Text := IntToStr(bArr[0]);
  end;

  if (m_hHandleSer <> 0) Then
  begin
    ZMB_ReadCoil(m_hHandleSer, m_iIDSer, iAddr, 1, @bArr[0], 0);
    CoilSData.Text := IntToStr(bArr[0]);
  end;


end;

procedure TForm1.BtnConnectSerClick(Sender: TObject);
var
iDB : Integer;
iCB : Integer;
iSB : Integer;
iTimeOut : Integer;
iBaud: Integer;
iWorkMode :Integer;

begin
  if RadioButtonRTU.Checked = true then
    iWorkMode := 0
  else
    iWorkMode := 1;

  iBaud := StrToInt( ComboBoxBaud.Text);
  iDB := StrToInt(EditDBSer.Text);
  iCB := StrToInt(EditCBSer.Text);
  iSB := StrToInt(EditSBSer.Text);
  iTimeOut := StrToInt(EditTimeoutSer.Text);

  m_iIDSer := StrToInt(EditIDSer.Text);

  m_hHandleSer :=  ZMB_SerConnectMDBServer( iWorkMode, PChar(ComboBoxCOM.Text), iBaud,  iDB, iCB, iSB,
    0, 0, 0, 0, iTimeOut);

  If (m_hHandleSer <> 0) Then
      ShowMessage ('ӵɹ')
  Else
      ShowMessage ('ӵʧ');

end;

procedure TForm1.BtnCoilSWriteClick(Sender: TObject);
var
iAddr : Integer;
iData : smallint;
begin
  iAddr := StrToInt(CoilSAddr.Text);
  iData := StrToInt(CoilSData.Text);

  if (m_hHandleEth <> 0) Then
    ZMB_WriteCoilSingle(m_hHandleEth, m_iIDEth, iAddr, iData, 0);

  if (m_hHandleSer <> 0) Then
    ZMB_WriteCoilSingle(m_hHandleSer, m_iIDSer, iAddr, iData, 0);
end;

procedure TForm1.BtnCoilMReadClick(Sender: TObject);
var
bArr: array[0..100] of Byte;
iRet: Integer;
iAddr: integer;
iCount: integer;
begin
  iAddr := StrToInt(CoilMAddr.Text);
  iCount := StrToInt(CoilMCount.Text);

  if (m_hHandleEth <> 0) Then
  begin
    ZMB_ReadCoil(m_hHandleEth, m_iIDEth, iAddr, iCount, @bArr[0], 0);
    CoilMData1.Text := IntToStr(bArr[0]);
    CoilMData2.Text := IntToStr(bArr[1]);
  end;

  if (m_hHandleSer <> 0) Then
  begin
    ZMB_ReadCoil(m_hHandleSer, m_iIDSer, iAddr, iCount, @bArr[0], 0);
    CoilMData1.Text := IntToStr(bArr[0]);
    CoilMData2.Text := IntToStr(bArr[1]);
  end;


end;

procedure TForm1.BtnCoilMWriteClick(Sender: TObject);
var
iAddr : Integer;
bData: array[0..100] of Byte;
iCount : Integer;
begin
  iAddr := StrToInt(CoilMAddr.Text);
  iCount := StrToInt(CoilMCount.Text);

  bData[0] := StrToInt(CoilMData1.Text);
  bData[1] := StrToInt(CoilMData2.Text);

  if (m_hHandleEth <> 0) Then
    ZMB_WriteCoilMulitiple(m_hHandleEth, m_iIDEth, iAddr, iCount, @bData[0], 0);

  if (m_hHandleSer <> 0) Then
    ZMB_WriteCoilMulitiple(m_hHandleSer, m_iIDSer, iAddr, iCount, @bData[0], 0);

end;

procedure TForm1.BtnRegSReadClick(Sender: TObject);
var
iArr: array[0..100] of SmallInt;
iRet: Integer;
iAddr: integer;
begin
  iAddr := StrToInt(RegSAddr.Text);

  if (m_hHandleEth <> 0) Then
  begin
    ZMB_ReadHoldReg(m_hHandleEth, m_iIDEth, iAddr, 1, @iArr[0], 0);
    RegSData.Text := IntToStr(iArr[0]);
  end;

  if (m_hHandleSer <> 0) Then
  begin
    ZMB_ReadHoldReg(m_hHandleSer, m_iIDSer, iAddr, 1, @iArr[0], 0);
    RegSData.Text := IntToStr(iArr[0]);
  end;

end;

procedure TForm1.BtnRegSWriteClick(Sender: TObject);
var
iAddr : Integer;
iData : smallint;
begin
  iAddr := StrToInt(RegSAddr.Text);
  iData := StrToInt(RegSData.Text);

  if (m_hHandleEth <> 0) Then
    ZMB_WriteRegSingle(m_hHandleEth, m_iIDEth, iAddr, iData, 0);

  if (m_hHandleSer <> 0) Then
    ZMB_WriteRegSingle(m_hHandleSer, m_iIDSer, iAddr, iData, 0);
end;
procedure TForm1.BtnRegMReadClick(Sender: TObject);
var
iArr: array[0..100] of SmallInt;
iRet: Integer;
iAddr: integer;
iCount: integer;
begin
  iAddr := StrToInt(RegMAddr.Text);
  iCount := StrToInt(RegMCount.Text);

  if (m_hHandleEth <> 0) Then
  begin
    ZMB_ReadHoldReg(m_hHandleEth, m_iIDEth, iAddr, iCount, @iArr[0], 0);
    RegMData1.Text := IntToStr(iArr[0]);
    RegMData2.Text := IntToStr(iArr[1]);
  end;

  if (m_hHandleSer <> 0) Then
  begin
    ZMB_ReadHoldReg(m_hHandleSer, m_iIDSer, iAddr, iCount, @iArr[0], 0);
    RegMData1.Text := IntToStr(iArr[0]);
    RegMData2.Text := IntToStr(iArr[1]);
  end;

end;

procedure TForm1.BtnRegMWriteClick(Sender: TObject);
var
iAddr : Integer;
bData: array[0..100] of SmallInt;
iCount : Integer;
begin
  iAddr := StrToInt(RegMAddr.Text);
  iCount := StrToInt(RegMCount.Text);

  bData[0] := StrToInt(RegMData1.Text);
  bData[1] := StrToInt(RegMData2.Text);

  if (m_hHandleEth <> 0) Then
    ZMB_WriteRegMulitiple(m_hHandleEth, m_iIDEth, iAddr, iCount, @bData[0], 0);

  if (m_hHandleSer <> 0) Then
    ZMB_WriteRegMulitiple(m_hHandleSer, m_iIDSer, iAddr, iCount, @bData[0], 0);
end;

procedure TForm1.Button7Click(Sender: TObject);
var
bData: array[0..100] of byte;
begin
  bData[0] := 0;
  bData[1] := 3;
  bData[2] := 0;
  bData[3] := 0;
  bData[4] := 0;
  bData[5] := 6;
  bData[6] := 1;
  bData[7] := 1;
  bData[8] := 0;
  bData[9] := 0;
  bData[10] := 0;
  bData[11] := 0;
  bData[12] := 1;
                     
  if (m_hHandleEth <> 0) Then
    ZMB_WriteCmdBuf(m_hHandleEth,  @bData[0], 10,0);

  if (m_hHandleSer <> 0) Then
    ZMB_WriteCmdBuf(m_hHandleSer,  @bData[0], 10, 0);

end;

procedure TForm1.Button6Click(Sender: TObject);
var
bData: array[0..100] of byte;
iReadLen : integer;
begin
  if (m_hHandleEth <> 0) Then
    ZMB_ReadRecBuf(m_hHandleEth,  @bData[0], 100, @iReadLen, 0);

  if (m_hHandleSer <> 0) Then
    ZMB_ReadRecBuf(m_hHandleSer,  @bData[0], 100, @iReadLen, 0);


end;

procedure TForm1.Button5Click(Sender: TObject);
begin
    if (m_hHandleEth <> 0) Then
    begin
      ZMB_DisConnectMDBServer(m_hHandleEth);
      m_hHandleEth := 0;
    end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
          
    if (m_hHandleSer <> 0) Then
    begin
      ZMB_DisConnectMDBServer(m_hHandleSer);
      m_hHandleSer := 0;
    end;
end;

end.
